// pce.h

#ifndef __PCE_H_DEFINED__
#define __PCE_H_DEFINED__

enum _VDC_REG {
  MAWR, // 0x00
  MARR, // 0x01
  VWR,  // 0x02
  vdc3, // 0x03 
  vdc4, // 004
  CR,   // 05
  RCR,  // 06
  BXR,  // 07
  BYR,  // 08
  MWR,  // 09
  HSR,  // 0a
  HDR,  // 0b
  VPR,  // 0c
  VDW,  // 0d
  VCR,  // 0e
  DCR,  // 0f
  SOUR, // 10
  DISTR,// 11
  LENR, // 12
  SATB  // 13
};

#define	NODATA	0xff
#define	ENABLE	1
#define	DISABLE	0

#define	VDC_CR	0x01
#define	VDC_OR	0x02
#define	VDC_RR	0x04
#define	VDC_DS	0x08
#define	VDC_DV	0x10
#define	VDC_VD	0x20
#define	VDC_BSY	0x40
#define	VDC_SpHit	VDC_CR
#define	VDC_Over	VDC_OR
#define	VDC_RasHit	VDC_RR
#define	VDC_InVBlank VDC_VD
#define	VDC_DMAfinish	VDC_DV
#define	VDC_SATBfinish	VDC_DS

#define	SpHitON		(io.VDC[CR].W&0x01)
#define	OverON		(io.VDC[CR].W&0x02)
#define	RasHitON	(io.VDC[CR].W&0x04)
#define	VBlankON	(io.VDC[CR].W&0x08)
#define	SpriteON	(io.VDC[CR].W&0x40)
#define	ScreenON	(io.VDC[CR].W&0x80)

#define SATBIntON	(io.VDC[DCR].W&0x01)
#define DMAIntON	(io.VDC[DCR].W&0x02)

#define	IRQ2	1
#define	IRQ1	2
#define	TIRQ	4
#define	ScrollX	io.VDC[BXR].W
#define	ScrollY	io.VDC[BYR].W

#if 0 // psp
#define USE_SPRITE_CACHE
#endif

// PSP
#ifdef PALWORD
#define	WIDTH  	512 //(352+64)
#define	HEIGHT	256
#else//PALWORD
#define	WIDTH  	(352+64)
#define	HEIGHT	256
#endif//PALWORD

#define	JOY_A		0x0001
#define	JOY_B		0x0002
#define	JOY_SELECT	0x0004
#define	JOY_START	0x0008
#define	JOY_UP		0x0010
#define	JOY_DOWN	0x0040
#define	JOY_LEFT	0x0080
#define	JOY_RIGHT	0x0020
#define JOY_SIX		0xf000
#define	JOY_C		0x0100
#define JOY_D		0x0200
#define	JOY_E		0x0400
#define JOY_F		0x0800

#define	JOY_AR		0x00010001
#define	JOY_BR		0x00010002
#define	JOY_CR		0x00010100
#define JOY_DR		0x00010200
#define	JOY_ER		0x00010400
#define JOY_FR		0x00010800


#define	VRAMSIZE	0x20000

#include "M6502.h"

typedef struct tagIO {
	pair VDC[32];
//	byte VDC_ratch[32];
	pair VCE[0x200];
	pair vce_reg;
	byte vce_cr;	// add (ver0.12)
	/* VDC */
	word vdc_inc,vdc_raster_count;
	byte vdc_reg,vdc_status,vdc_ratch,vce_ratch;
//	byte vdc_iswrite_h;
	byte vdc_satb;
	byte vdc_pendvsync;
	int bg_h,bg_w;
	int screen_w,screen_h;
	int scroll_y;
	int minline, maxline;
	/* joypad */
	short JOY[16];
	int shiftmode[16];
	byte joy_select,joy_counter;

  // ̃WX^͎ۂ̏ł͎gȂ̂Œ
  // Xe[gt@Č݊̂߂̃f[^
  /* PSG */
	byte PSG[6][8];
    byte wave[6][32];
    byte wavofs[6];
	byte psg_ch,psg_volume,psg_lfo_freq,psg_lfo_ctrl;
  
	/* TIMER */
	byte timer_reload,timer_start,timer_counter;
	/* IRQ */
	byte irq_mask,irq_status;
  
#ifdef CDEMULATION  
	/* CDROM extention */
	int backup,adpcm_firstread;
	pair adpcm_ptr;
	word adpcm_rptr,adpcm_wptr;
/* CAREFUL, added variable */
   word adpcm_dmaptr;

/* CAREFUL, added variable */
   byte adpcm_rate;

/* CAREFUL, added variable */
   DWORD adpcm_pptr; /* to know where to begin playing adpcm (in nibbles) */

/* CAREFUL, added variable */
   DWORD adpcm_psize; /* to know how many 4-bit samples to play */
#endif//CDEMULATION  
} IO;


// CDɑΉĂȂZ[uf[^ǂނ
typedef struct tagIO_nocd {
	pair VDC[32];
//	byte VDC_ratch[32];
	pair VCE[0x200];
	pair vce_reg;
	byte vce_cr;	// add (ver0.12)
	/* VDC */
	word vdc_inc,vdc_raster_count;
	byte vdc_reg,vdc_status,vdc_ratch,vce_ratch;
//	byte vdc_iswrite_h;
	byte vdc_satb;
	byte vdc_pendvsync;
	int bg_h,bg_w;
	int screen_w,screen_h;
	int scroll_y;
	int minline, maxline;
	/* joypad */
	short JOY[16];
	int shiftmode[16];
	byte joy_select,joy_counter;
	/* PSG */
	byte PSG[8][8];
    byte wave[8][32]; /* add by e */
    byte wavofs[8];
	byte psg_ch,psg_volume,psg_lfo_freq,psg_lfo_ctrl;
	/* TIMER */
	byte timer_reload,timer_start,timer_counter;
	/* IRQ */
	byte irq_mask,irq_status;
/* CAREFUL, added variable */
   word adpcm_dmaptr;

/* CAREFUL, added variable */
   byte adpcm_rate;

/* CAREFUL, added variable */
   DWORD adpcm_pptr; /* to know where to begin playing adpcm (in nibbles) */

/* CAREFUL, added variable */
   DWORD adpcm_psize; /* to know how many 4-bit samples to play */
} IO_nocd;
// CDɑΉĂȂZ[uf[^ǂނ



extern IO  io;
extern int UPeriod;
extern int BaseClock;
extern int OrigBaseClock;

int CartLoad(char *name);

int RunPCE(void);

void ResetPCE(M6502 *M);
int InitPCE(char*,char*); //int InitPCE(char *name);
void TrashPCE(void);
BOOL InitMachine(void);
void TrashMachine(void);
int Joysticks(short *JS);
DWORD  msf2nb_sect(byte min, byte sec, byte fra);
void    fill_cd_info();
void    nb_sect2msf(DWORD lsn,byte *min, byte *sec, byte *frm);

#ifdef MOVIE
// =-=- for Movie
extern short	*pusMovie[5];
extern int		iMoviePtr[5];
extern int		iMaxMoviePtr[5];
extern short	joy_before[5];
extern short	joy_counter[5];
extern int		iMode;
extern int		iMovieFilePtr;
extern int		iModeChange;
#define			MOVIE_NOTHING	0
#define			MOVIE_WRITE		1
#define			MOVIE_READ		2

// =-=- for Network
extern CRITICAL_SECTION	cs;
#endif//MOVIE


#ifdef CDEMULATION
// =-=- for CDROM
void pce_cd_read_sector (void);
extern byte PCM[];
// ADPCM buffer
extern byte cd_port_1800;
extern byte cd_port_1801;
extern byte cd_port_1802;
extern byte cd_port_1804;
extern byte bcdbin[0x100];
extern byte binbcd[0x100];
extern byte cd_sector_buffer[0x2000];
extern byte cd_extra_mem[0x10000];
// extra ram provided by the system CD card

extern byte *cd_read_buffer;
extern byte cd_extra_super_mem[0x30000];
extern DWORD pce_cd_read_datacnt;
extern DWORD pce_cd_sectoraddy;
extern byte cd_sectorcnt;
typedef struct
    {
     DWORD offset;
     byte  new_val;
     } PatchEntry;
typedef struct
    {
     DWORD StartTime;
     DWORD Duration;
     char data[32];

     } SubtitleEntry;


typedef enum {
	HCD_SOURCE_REGULAR_FILE,
        HCD_SOURCE_CD_TRACK
	} hcd_source_type;

typedef struct
    {
     byte beg_min;
     byte beg_sec;
     byte beg_fra;

     byte type;

     DWORD beg_lsn;
     DWORD length;

     hcd_source_type source_type;
     char filename[256];

     DWORD patch_number;
     DWORD subtitle_number;

     byte subtitle_synchro_type;

     PatchEntry *patch;
     SubtitleEntry *subtitle;

     } Track;

extern Track CD_track[0x100];

extern byte nb_max_track;

extern BOOL pce_enable_cdrom;
extern char ISO_filename[256];
extern byte CD_emulation;
#endif//CDEMULATION

extern byte VRAM[VRAMSIZE];
extern byte vchange[VRAMSIZE / 32];
extern byte WRAM[0x2000];
extern byte DMYROM[0x2000];
extern byte IOAREA[0x2000];
extern byte PCM[0x10000];
extern M6502 M;
extern IO   io;
extern byte RAM[0x8000];
extern byte PopRAM[0x10000];
extern byte *Page[8],*ROMMap[512];
extern short SPRAM[64*4];
extern unsigned long VRAM2[VRAMSIZE / sizeof(unsigned long)];
extern int scanline;


#ifdef PALWORD         //------------------------------------------------------

typedef unsigned short PALFMT;

#else//PALWORD         //------------------------------------------------------

typedef unsigned char PALFMT;

#endif//PALWORD        //------------------------------------------------------

extern PALFMT * XBuf;
extern PALFMT huePal[512];


extern byte populus;
extern byte vchanges[VRAMSIZE/128];
extern int ROM_size;
extern byte *ROM;

extern byte CDBIOS_replace[0x4d][2];
extern byte *Page[];

// for PSP
void initSound(void);
void closeSound(void);

void VDC_write(word A,byte V);
void VCE_write(word A,byte V);
void PSG_write(word A,byte V);

byte VDC_read(word A);
byte VCE_read(word A);
byte PSG_read(word A);

#endif
